<?php $__env->startSection('title', 'Cinestacion'); ?>

<head>
    <link rel="icon" href="<?php echo e(asset('imagenes/icon.png')); ?>" type="image/x-icon">
</head>

<?php $__env->startSection('content_header'); ?>
    <?php if($alertaSalas): ?>
    <div class="alert alert-danger text-center">
        ⚠️ ¡Atención! Solo quedan <?php echo e($salasDisponibles); ?> salas disponibles.
    </div>
    <?php endif; ?>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('content'); ?>
<div class="container-fluid">
    <!-- Primera fila de métricas -->
    <div class="row">
        <!-- Películas Disponibles -->
        <div class="col-lg-3 col-md-6 col-12">
            <div class="small-box" style="background-color: #FF0033; color: white;">
                <div class="inner">
                    <h3><?php echo e($totalPeliculas); ?></h3>
                    <p>Películas Disponibles</p>
                </div>
                <div class="icon"><i class="fas fa-film" style="color: white;"></i></div>
            </div>
        </div>

        <!-- Alquileres Activos -->
        <div class="col-lg-3 col-md-6 col-12">
            <div class="small-box" onclick="window.location='<?php echo e(route('alquileres.index')); ?>'" style="cursor: pointer; background-color: #00CC99; color: white;">
                <div class="inner">
                    <h3><?php echo e($totalAlquileres); ?></h3>
                    <p>Alquileres Activos</p>
                </div>
                <div class="icon"><i class="fas fa-handshake" style="color: white;"></i></div>
            </div>
        </div>

        <!-- Salas Disponibles -->
        <div class="col-lg-3 col-md-6 col-12">
            <div class="small-box" style="background-color: #FFCC00; color: white;">
                <div class="inner">
                    <h3><?php echo e($salasDisponibles); ?></h3>
                    <p>Salas Disponibles</p>
                </div>
                <div class="icon"><i class="fas fa-door-open" style="color: white;"></i></div>
            </div>
        </div>

        <!-- Total Ingresos -->
        <div class="col-lg-3 col-md-6 col-12">
    <div class="small-box" style="background-color: #00CED1; color: white; box-shadow: 0px 0px 15px rgba(0, 206, 209, 0.7);">
        <div class="inner">
            <h3>S/. <?php echo e(number_format($ingresosTotalesHoy, 2)); ?></h3>
            <p>Total Ingresos del Día</p>
        </div>
        <div class="icon"><i class="fas fa-calendar-day" style="color: white;"></i></div>
    </div>
</div>
        </div>
    </div>

    
    <div class="row">
        
        <div class="col-md-4 col-12">
            <div class="small-box" style="background-color: #9933FF; color: white;">
                <div class="inner">
                    <h3>S/. <?php echo e(number_format($ingresosDiariosPeliculas, 2)); ?></h3>
                    <p>Ingresos Diarios (Películas)</p>
                </div>
                <div class="icon"><i class="fas fa-video" style="color: white;"></i></div>
            </div>
        </div>

        
        <div class="col-md-4 col-12">
            <div class="small-box" style="background-color: #FF6600; color: white;">
                <div class="inner">
                    <h3>S/. <?php echo e(number_format($ingresosDiariosProductos, 2)); ?></h3>
                    <p>Ingresos Diarios (Productos)</p>
                </div>
                <div class="icon"><i class="fas fa-popcorn" style="color: white;"></i></div>
            </div>
        </div>
        
        
        <div class="col-md-4 col-12">
            <div class="small-box" onclick="window.location='<?php echo e(route('reporte.index')); ?>'" style="cursor: pointer; background-color: #00CC99; color: white;">
                <div class="inner">
                    <h3><i class="fas fa-file-pdf"></i></h3>
                    <p>Generar Reporte</p>
                </div>
                <div class="icon"><i class="fas fa-chart-bar" style="color: white;"></i></div>
            </div>
        </div>
    </div>

    
    <div class="row mt-4">
        <form id="filterForm" class="d-flex flex-wrap align-items-center" style="margin-bottom: 15px;">
            <input type="date" id="startDate" class="form-control form-control-sm mx-1" style="max-width: 120px;">
            <input type="date" id="endDate" class="form-control form-control-sm mx-1" style="max-width: 120px;">
            <button type="button" class="btn btn-sm btn-outline-danger mx-1" onclick="updateChart()">Filtrar</button>
        </form>
    </div>

    
    <div class="row mt-4">
        
        <div class="col-lg-6 col-md-12">
            <div class="card shadow-sm border-0">
                <div class="card-header d-flex flex-wrap justify-content-between">
                    <h3 class="card-title">📊 Ingresos Diarios (Precio de Alquiler)</h3>
                </div>
                <div class="card-body">
                    <canvas id="simulatedChart" style="max-height: 300px; width: 100%;"></canvas>
                </div>
            </div>
        </div>

        
        <div class="col-lg-6 col-md-12">
            <div class="card shadow-sm border-0">
                <div class="card-header d-flex flex-wrap justify-content-between">
                    <h3 class="card-title">📊 Ingresos total por productos diario</h3>
                </div>
                <div class="card-body">
                    <canvas id="ingresosDiariosChart" style="max-height: 300px; width: 100%;"></canvas>
                </div>
            </div>
        </div>
    </div>

    
    <div class="row mt-4">
        
        <div class="col-lg-6 col-md-12">
            <div class="card shadow-sm border-0">
                <div class="card-header bg-success text-white">
                    <h3 class="card-title">Películas Más Rentadas</h3>
                </div>
                <div class="card-body">
                    <div class="table-responsive">
                        <table class="table table-hover">
                            <thead class="table-light">
                                <tr>
                                    <th>Película</th>
                                    <th>Alquileres</th>
                                </tr>
                            </thead>
                            <tbody>
                                <?php
                                    $maxAlquileres = $topPeliculas->max('total') ?? 1;
                                    $coloresNeon = ['#FF0033', '#00FF99', '#FFCC00', '#3399FF', '#9933FF'];
                                ?>
                                <?php $__currentLoopData = $topPeliculas; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $index => $pelicula): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                    <?php
                                        $porcentaje = ($pelicula->total / $maxAlquileres) * 100;
                                        $color = $coloresNeon[$index % count($coloresNeon)];
                                    ?>
                                    <tr>
                                        <td><?php echo e($pelicula->nombre); ?></td>
                                        <td class="text-center">
                                            <div class="progress" style="height: 20px; background-color: rgba(255, 255, 255, 0.2);">
                                                <div class="progress-bar" role="progressbar"
                                                    style="width: <?php echo e($porcentaje); ?>%; background-color: <?php echo e($color); ?>; box-shadow: 0px 0px 10px <?php echo e($color); ?>;"
                                                    aria-valuenow="<?php echo e($pelicula->total); ?>" aria-valuemin="0" aria-valuemax="<?php echo e($maxAlquileres); ?>">
                                                    <?php echo e($pelicula->total); ?>

                                                </div>
                                            </div>
                                        </td>
                                    </tr>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                            </tbody>
                        </table>
                    </div>
                </div>
            </div>
        </div>

        
        <div class="col-lg-6 col-md-12">
            <div class="card shadow-sm border-0">
                <div class="card-header bg-warning text-dark">
                    <h3 class="card-title">Últimos Pagos Recibidos</h3>
                </div>
                <div class="card-body">
                    <div class="list-group">
                        <?php $__currentLoopData = $ultimosCobros; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $cobro): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <div class="list-group-item d-flex justify-content-between align-items-center border rounded-3 mb-3" style="background-color: #f7f7f7; box-shadow: 0px 2px 6px rgba(0, 0, 0, 0.1);">
                                <div>
                                    <h6 class="text-dark" style="font-size: 1.2rem; font-weight: 600;"><?php echo e($cobro->titulo); ?></h6>
                                    <p class="mb-1" style="font-size: 1rem; font-weight: 500; color: #007bff;"><strong>Precio:</strong> S/. <?php echo e(number_format($cobro->precio, 2)); ?></p>
                                    <small class="text-muted" style="font-size: 0.9rem;"><?php echo e($cobro->fecha_cobro); ?></small>
                                </div>
                            </div>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>
<?php $__env->stopSection(); ?>

<?php $__env->startPush('js'); ?>
<script src="https://cdn.jsdelivr.net/npm/chart.js"></script>
<script src="https://cdn.jsdelivr.net/npm/moment@2.29.1/moment.min.js"></script>
<script src="https://cdn.jsdelivr.net/npm/moment@2.29.1/locale/es.js"></script>
<script src="https://cdn.jsdelivr.net/npm/sweetalert2@11"></script>

<script>
// Variable global para guardar el gráfico
var chartInstance;

document.addEventListener("DOMContentLoaded", function () {
    // Establecer las fechas por defecto al cargar la página como los últimos 7 días
    const fechaInicio = '<?php echo e($startDate); ?>';
    const fechaFin = '<?php echo e($endDate); ?>';
    document.getElementById('startDate').value = fechaInicio;
    document.getElementById('endDate').value = fechaFin;

    // Llamar la función de actualización del gráfico al cargar la página
    updateChart(fechaInicio, fechaFin);
});

// Función para actualizar el gráfico
function updateChart(fechaInicio, fechaFin) {
    // Obtener el contexto del canvas
    var ctx = document.getElementById('simulatedChart').getContext('2d');

    // Si existe un gráfico previo, destruirlo
    if (chartInstance) {
        chartInstance.destroy();
    }

    // Enviar las fechas al servidor para obtener los datos filtrados
    fetch(`/dashboard/ingresos-diarios?startDate=${fechaInicio}&endDate=${fechaFin}`)
        .then(response => response.json())
        .then(data => {
            // Verificar si los datos llegan correctamente
            console.log("Datos recibidos:", data);

            // Extraer las fechas y montos
            var fechas = data.fechas;
            var montos = data.montos;

            // Si no hay datos, simplemente no hacer nada y salir de la función
            if (fechas.length === 0 || montos.length === 0) {
                return;
            }

            // Asignar colores diferentes a cada barra
            var colores = ['#FF0033', '#FF6600', '#FFCC00', '#3399FF', '#9933FF', '#00CC99', '#FF6699'];
            var coloresBarras = fechas.map((_, index) => colores[index % colores.length]);

            // Invertir las fechas y montos para mostrar la fecha más reciente a la izquierda
            var fechasInversas = fechas.reverse();
            var montosInversos = montos.reverse();

            // Formatear las fechas para mostrar el nombre del día + la fecha
            var fechasFormateadas = fechasInversas.map(fecha => {
                return moment(fecha).format('dddd, YYYY-MM-DD');
            });

            // Crear el gráfico con los nuevos datos
            chartInstance = new Chart(ctx, {
                type: 'bar',
                data: {
                    labels: fechasFormateadas,
                    datasets: [{
                        label: 'Ingresos Diarios',
                        data: montosInversos,
                        backgroundColor: coloresBarras,
                        borderColor: coloresBarras,
                        borderWidth: 1
                    }]
                },
                options: {
                    responsive: true,
                    plugins: {
                        title: {
                            display: true,
                            text: 'Ingresos Diarios'
                        },
                        tooltip: {
                            enabled: true,
                            mode: 'index',
                            intersect: false,
                            callbacks: {
                                label: function(tooltipItem) {
                                    return 'S/. ' + tooltipItem.parsed.y.toFixed(2);
                                }
                            }
                        }
                    },
                    scales: {
                        x: {
                            title: {
                                display: true,
                                text: 'Fecha'
                            },
                            ticks: {
                                display: false,
                                autoSkip: false,
                                maxRotation: 90,
                                minRotation: 45
                            }
                        },
                        y: {
                            title: {
                                display: true,
                                text: 'Ingresos (S/.)'
                            },
                            ticks: {
                                beginAtZero: true
                            }
                        }
                    }
                }
            });
        })
        .catch(error => {
            console.error("Error al obtener los datos:", error);
        });
}

// Cuando se hace clic en el botón de filtrar
document.querySelector("button").addEventListener("click", function() {
    const startDate = document.getElementById('startDate').value;
    const endDate = document.getElementById('endDate').value;
    updateChart(startDate, endDate);
});



</script>
<?php $__env->stopPush(); ?>
<?php echo $__env->make('adminlte::page', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH C:\xampp\htdocs\cinema-laravel11\resources\views/dashboard.blade.php ENDPATH**/ ?>