

<?php $__env->startSection('title', 'Editar Alquiler'); ?>

<head>
    <link rel="icon" href="<?php echo e(asset('icons/servicio.png')); ?>" type="image/x-icon">
    <link href="https://cdn.jsdelivr.net/npm/select2@4.0.13/dist/css/select2.min.css" rel="stylesheet">
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/bootstrap-datetimepicker/4.17.47/css/bootstrap-datetimepicker.min.css">
</head>

<?php $__env->startSection('content_header'); ?>
    <div class="d-flex justify-content-between align-items-center">
        <h1 class="m-0 text-dark">Editar Alquiler</h1>
        <a href="<?php echo e(route('alquileres.index')); ?>" class="btn btn-outline-secondary">
            <i class="fas fa-arrow-left"></i> Volver
        </a>
    </div>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('content'); ?>
    <div class="card shadow">
        <div class="card-header bg-primary">
            <h3 class="card-title mb-0 text-white">
                <i class="fas fa-edit mr-2"></i>Formulario de Edición
            </h3>
        </div>
        
        <div class="card-body">
            <?php if($errors->any()): ?>
                <div class="alert alert-danger alert-dismissible fade show">
                    <button type="button" class="close" data-dismiss="alert" aria-label="Close">
                        <span aria-hidden="true">&times;</span>
                    </button>
                    <h5><i class="icon fas fa-ban"></i> Error de Validación!</h5>
                    <ul class="mb-0">
                        <?php $__currentLoopData = $errors->all(); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $error): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <li><?php echo e($error); ?></li>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                    </ul>
                </div>
            <?php endif; ?>

            <form action="<?php echo e(route('alquileres.update', $alquiler->id ?? '')); ?>" method="POST" class="needs-validation" novalidate>
                <?php echo csrf_field(); ?>
                <?php echo method_field('PUT'); ?>

                <div class="row">
                    <div class="col-md-6">
                        <div class="form-group">
                            <label for="pelicula_id" class="font-weight-bold">Película</label>
                            <select name="pelicula_id" id="pelicula_id" class="form-control select2" required style="width: 100%;">
                                <option value="">Seleccione una película</option>
                                <?php $__currentLoopData = $peliculas; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $pelicula): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                    <option value="<?php echo e($pelicula->id); ?>" 
                                        <?php echo e(old('pelicula_id', $alquiler->pelicula_id ?? '') == $pelicula->id ? 'selected' : ''); ?>>
                                        <?php echo e($pelicula->titulo); ?>

                                    </option>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                            </select>
                            <div class="invalid-feedback">
                                Por favor seleccione una película.
                            </div>
                        </div>
                    </div>

                    <div class="col-md-6">
                        <div class="form-group">
                            <label for="cliente" class="font-weight-bold">Cliente</label>
                            <div class="input-group">
                                <div class="input-group-prepend">
                                    <span class="input-group-text"><i class="fas fa-user"></i></span>
                                </div>
                                <input type="text" name="cliente" id="cliente" class="form-control" required
                                    value="<?php echo e(old('cliente', $alquiler->cliente ?? '')); ?>" placeholder="Nombre del cliente">
                                <div class="invalid-feedback">
                                    Por favor ingrese el nombre del cliente.
                                </div>
                            </div>
                        </div>
                    </div>
                </div>

                <div class="row mt-3">
                    <div class="col-md-6">
                        <div class="form-group">
                            <label for="hora_entrada" class="font-weight-bold">Hora de Entrada</label>
                            <div class="input-group date" id="horaEntradaPicker">
                                <div class="input-group-prepend">
                                    <span class="input-group-text"><i class="far fa-clock"></i></span>
                                </div>
                                <input type="text" name="hora_entrada" class="form-control datetimepicker-input" 
                                    value="<?php echo e(old('hora_entrada', $alquiler->hora_entrada ?? '')); ?>" 
                                    data-toggle="datetimepicker" data-target="#horaEntradaPicker"/>
                            </div>
                        </div>
                    </div>

                    <div class="col-md-6">
                        <div class="form-group">
                            <label for="hora_salida" class="font-weight-bold">Hora de Salida</label>
                            <div class="input-group date" id="horaSalidaPicker">
                                <div class="input-group-prepend">
                                    <span class="input-group-text"><i class="far fa-clock"></i></span>
                                </div>
                                <input type="text" name="hora_salida" class="form-control datetimepicker-input" 
                                    value="<?php echo e(old('hora_salida', $alquiler->hora_salida ?? '')); ?>" 
                                    data-toggle="datetimepicker" data-target="#horaSalidaPicker"/>
                            </div>
                        </div>
                    </div>
                </div>

                <div class="row mt-3">
                    <div class="col-md-6">
                        <div class="form-group">
                            <label for="precio" class="font-weight-bold">Precio del Alquiler</label>
                            <div class="input-group">
                                <div class="input-group-prepend">
                                    <span class="input-group-text"><i class="fas fa-dollar-sign"></i></span>
                                </div>
                                <input type="number" step="0.01" class="form-control" id="precio" name="precio" required
                                    value="<?php echo e(old('precio', $alquiler->precio ?? '')); ?>" placeholder="0.00">
                                <div class="invalid-feedback">
                                    Por favor ingrese un precio válido.
                                </div>
                            </div>
                        </div>
                    </div>
                </div>

                <div class="card-footer bg-white d-flex justify-content-between align-items-center mt-4">
                    <button type="reset" class="btn btn-outline-danger">
                        <i class="fas fa-undo mr-1"></i> Limpiar
                    </button>
                    <button type="submit" class="btn btn-primary">
                        <i class="fas fa-save mr-1"></i> Guardar Cambios
                    </button>
                </div>
            </form>
        </div>
    </div>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('js'); ?>
    <script src="https://cdn.jsdelivr.net/npm/select2@4.0.13/dist/js/select2.min.js"></script>
    <script src="https://cdnjs.cloudflare.com/ajax/libs/moment.js/2.29.1/moment.min.js"></script>
    <script src="https://cdnjs.cloudflare.com/ajax/libs/bootstrap-datetimepicker/4.17.47/js/bootstrap-datetimepicker.min.js"></script>
    
    <script>
        $(document).ready(function() {
            // Initialize Select2
            $('.select2').select2({
                placeholder: "Seleccione una película",
                allowClear: true,
                theme: 'bootstrap4'
            });

            // Initialize datetime picker
            $('#horaEntradaPicker').datetimepicker({
                format: 'HH:mm',
                stepping: 15,
                useCurrent: false
            });
            
            $('#horaSalidaPicker').datetimepicker({
                format: 'HH:mm',
                stepping: 15,
                useCurrent: false
            });

            // Form validation
            (function() {
                'use strict';
                window.addEventListener('load', function() {
                    var forms = document.getElementsByClassName('needs-validation');
                    var validation = Array.prototype.filter.call(forms, function(form) {
                        form.addEventListener('submit', function(event) {
                            if (form.checkValidity() === false) {
                                event.preventDefault();
                                event.stopPropagation();
                            }
                            form.classList.add('was-validated');
                        }, false);
                    });
                }, false);
            })();

            // Show success message if exists
            <?php if(session('success')): ?>
                Swal.fire({
                    position: 'top-end',
                    icon: 'success',
                    title: '<?php echo e(session('success')); ?>',
                    showConfirmButton: false,
                    timer: 3000,
                    toast: true
                });
            <?php endif; ?>
        });
    </script>
<?php $__env->stopSection(); ?>
<?php echo $__env->make('adminlte::page', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH C:\xampp\htdocs\cinema-laravel11\resources\views/alquileres/edit.blade.php ENDPATH**/ ?>