

<?php $__env->startSection('title', 'Usuarios Registrados'); ?>

<?php $__env->startSection('css'); ?>
<style>
   /* Estilos generales */
   .card {
    border-radius: 15px;
    overflow: hidden;
    box-shadow: 0 4px 20px rgba(0, 0, 0, 0.1);
}

.card-header {
    background-color: #4e73df;
    color: white;
    padding: 15px;
    font-size: 1.25rem;
}

.card-header a {
    color: white;
    font-size: 1rem;
    border-radius: 10px;
    padding: 5px 10px;
    transition: background-color 0.3s;
}

.card-header a:hover {
    background-color: #2e59d9;
}

.card-body {
    padding: 20px;
}

.table-responsive {
    margin-top: 15px;
}

.table {
    width: 100%;
    border-collapse: collapse;
}

.table thead {
    background-color: #007bff;
    color: white;
}

.table th, .table td {
    padding: 15px;
    text-align: center;
    vertical-align: middle;
    border: 1px solid #ddd;
}

.table td {
    padding: 10px;
    vertical-align: middle;
}

.table tbody tr:nth-child(even) {
    background-color: #f8f9fc;
}

.table tbody tr:hover {
    background-color: #e9f0ff;
}

/* Toggle switch mejorado */
.toggle-container {
    display: flex;
    align-items: center;
    justify-content: center;
}

.toggle-switch {
    position: relative;
    display: inline-block;
    width: 60px;
    height: 34px;
}

.toggle-switch input {
    opacity: 0;
    width: 0;
    height: 0;
}

.toggle-slider {
    position: absolute;
    cursor: pointer;
    top: 0;
    left: 0;
    right: 0;
    bottom: 0;
    background-color: #ccc;
    transition: .4s;
    border-radius: 34px;
}

.toggle-slider:before {
    position: absolute;
    content: "";
    height: 26px;
    width: 26px;
    left: 4px;
    bottom: 4px;
    background-color: white;
    transition: .4s;
    border-radius: 50%;
}

input:checked + .toggle-slider {
    background-color: #28a745;
}

input:checked + .toggle-slider:before {
    transform: translateX(26px);
}

.toggle-status {
    margin-left: 10px;
    font-weight: bold;
    font-size: 14px;
}

.toggle-status.active {
    color: #28a745;
}

.toggle-status.inactive {
    color: #dc3545;
}

.super-admin-status {
    color: #6f42c1;
    font-weight: bold;
}

/* WhatsApp button */
.btn-whatsapp {
    background-color: #25D366;
    color: white;
    border: none;
    transition: all 0.3s;
}

.btn-whatsapp:hover {
    background-color: #128C7E;
    color: white;
    transform: translateY(-2px);
    box-shadow: 0 4px 8px rgba(0, 0, 0, 0.1);
}

/* Botones de acción */
.btn-action {
    transition: all 0.3s;
    margin: 2px;
}

.btn-action:hover {
    transform: translateY(-2px);
    box-shadow: 0 4px 8px rgba(0, 0, 0, 0.1);
}

.btn-edit {
    background-color: #ffc107;
    color: #212529;
}

.btn-edit:hover {
    background-color: #e0a800;
    color: #212529;
}

.btn-delete {
    background-color: #dc3545;
    color: white;
}

.btn-delete:hover {
    background-color: #c82333;
    color: white;
}

/* Modal styles */
.modal-header {
    background-color: #4e73df;
    color: white;
}

.whatsapp-icon {
    color: #25D366;
    font-size: 1.5rem;
    margin-right: 10px;
}

.form-control:focus {
    border-color: #25D366;
    box-shadow: 0 0 0 0.2rem rgba(37, 211, 102, 0.25);
}

.input-group-prepend .input-group-text {
    background-color: #e9ecef;
    font-weight: bold;
}

.template-tags {
    background-color: #f8f9fa;
    padding: 10px;
    border-radius: 5px;
    margin-bottom: 15px;
}

.template-tags span {
    display: inline-block;
    background-color: #e9ecef;
    padding: 2px 6px;
    margin: 2px;
    border-radius: 3px;
    font-size: 12px;
    cursor: pointer;
    transition: all 0.2s;
}

.template-tags span:hover {
    background-color: #dae0e5;
    transform: translateY(-1px);
}

/* Estilos para la imagen de perfil */
.profile-image {
    width: 50px;
    height: 50px;
    border-radius: 50%;
    object-fit: cover;
    border: 2px solid #ddd;
    transition: transform 0.3s;
}

.profile-image:hover {
    transform: scale(1.5);
    z-index: 10;
    position: relative;
}

.profile-image-placeholder {
    width: 50px;
    height: 50px;
    border-radius: 50%;
    background-color: #f0f0f0;
    display: flex;
    align-items: center;
    justify-content: center;
    color: #999;
    font-size: 20px;
    border: 2px solid #ddd;
}

/* Animaciones */
@keyframes fadeIn {
    from { opacity: 0; transform: translateY(10px); }
    to { opacity: 1; transform: translateY(0); }
}

.table tbody tr {
    animation: fadeIn 0.3s ease-out;
}
</style>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('content_header'); ?>
    <h1>Lista de Usuarios</h1>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('content'); ?>
<div class="card shadow-sm">
    <div class="card-body">
        <?php if(session('success')): ?>
            <div class="alert alert-success alert-dismissible fade show">
                <?php echo e(session('success')); ?>

                <button type="button" class="close" data-dismiss="alert" aria-label="Close">
                    <span aria-hidden="true">&times;</span>
                </button>
            </div>
        <?php endif; ?>
        <?php if($errors->any()): ?>
            <div class="alert alert-danger alert-dismissible fade show">
                <ul>
                    <?php $__currentLoopData = $errors->all(); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $error): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                        <li><?php echo e($error); ?></li>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                </ul>
                <button type="button" class="close" data-dismiss="alert" aria-label="Close">
                    <span aria-hidden="true">&times;</span>
                </button>
            </div>
        <?php endif; ?>
        <div class="table-responsive">
            <table class="table table-hover text-center">
                <thead class="bg-primary text-white">
                    <tr>
                        <th>ID</th>
                        <th>Foto</th>
                        <th>Nombre</th>
                        <th>Email</th>
                        <th>Fecha de Registro</th>
                        <th>Estado</th>
                        <th>Acciones</th>
                    </tr>
                </thead>
                <tbody>
                    <?php $__currentLoopData = $usuarios; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $usuario): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                        <tr>
                            <td><?php echo e($usuario->id); ?></td>
                            <td>
                                <?php if($usuario->foto): ?>
                                    <img src="<?php echo e(asset('storage/' . $usuario->foto)); ?>" 
                                         class="profile-image" 
                                         alt="Foto de perfil de <?php echo e($usuario->name); ?>">
                                <?php else: ?>
                                    <div class="profile-image-placeholder">
                                        <i class="fas fa-user"></i>
                                    </div>
                                <?php endif; ?>
                            </td>
                            <td><?php echo e($usuario->name); ?></td>
                            <td><?php echo e($usuario->email); ?></td>
                            <td><?php echo e($usuario->created_at->format('d/m/Y')); ?></td>
                            <td>
                                <?php if($usuario->hasRole('super-admin')): ?>
                                    <div class="toggle-container">
                                        <label class="toggle-switch">
                                            <input type="checkbox" id="switch-<?php echo e($usuario->id); ?>" 
                                                   disabled
                                                   checked>
                                            <span class="toggle-slider"></span>
                                        </label>
                                        <span class="toggle-status super-admin-status">
                                            Super Admin
                                        </span>
                                    </div>
                                <?php else: ?>
                                    <div class="toggle-container">
                                        <label class="toggle-switch">
                                            <input type="checkbox" id="switch-<?php echo e($usuario->id); ?>" 
                                                   onchange="cambiarEstadoUsuario(<?php echo e($usuario->id); ?>)"
                                                   <?php echo e($usuario->activo ? 'checked' : ''); ?>>
                                            <span class="toggle-slider"></span>
                                        </label>
                                        <span class="toggle-status <?php echo e($usuario->activo ? 'active' : 'inactive'); ?>">
                                            <?php echo e($usuario->activo ? 'Activo' : 'Inactivo'); ?>

                                        </span>
                                    </div>
                                <?php endif; ?>
                            </td>
                            <td class="d-flex justify-content-center flex-wrap">
                                <a href="<?php echo e(route('usuarios.edit', $usuario->id)); ?>" 
                                   class="btn btn-edit btn-sm btn-action">
                                    <i class="fas fa-edit"></i> Editar
                                </a>
                                <?php if(!$usuario->hasRole('super-admin')): ?>
                                <form action="<?php echo e(route('usuarios.destroy', $usuario->id)); ?>" method="POST" class="d-inline">
                                    <?php echo csrf_field(); ?>
                                    <?php echo method_field('DELETE'); ?>
                                    <button type="button" class="btn btn-delete btn-sm btn-action" 
                                            onclick="confirmarEliminacion(this)">
                                        <i class="fas fa-trash-alt"></i> Eliminar
                                    </button>
                                </form>
                                <?php endif; ?>
                                <button class="btn btn-whatsapp btn-sm btn-action" 
                                        data-toggle="modal" 
                                        data-target="#whatsappModal" 
                                        data-userid="<?php echo e($usuario->id); ?>" 
                                        data-username="<?php echo e($usuario->name); ?>" 
                                        data-useremail="<?php echo e($usuario->email); ?>" 
                                        data-userdate="<?php echo e($usuario->created_at->format('d/m/Y')); ?>"
                                        data-userpassword="<?php echo e($usuario->password_temp ?? 'P@ssw0rdT3mp'); ?>">
                                    <i class="fab fa-whatsapp"></i> WhatsApp
                                </button>
                            </td>
                        </tr>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                </tbody>
            </table>
        </div>

        <!-- Paginación -->
        <div class="d-flex justify-content-center mt-4">
            <?php echo e($usuarios->links('pagination::bootstrap-4')); ?>

        </div>
    </div>
</div>

<!-- Modal para enviar WhatsApp -->
<div class="modal fade" id="whatsappModal" tabindex="-1" role="dialog" aria-labelledby="whatsappModalLabel" aria-hidden="true">
    <div class="modal-dialog modal-lg" role="document">
        <div class="modal-content">
            <div class="modal-header">
                <h5 class="modal-title" id="whatsappModalLabel">
                    <i class="fab fa-whatsapp whatsapp-icon"></i> Enviar Credenciales por WhatsApp
                </h5>
                <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                    <span aria-hidden="true">&times;</span>
                </button>
            </div>
            <div class="modal-body">
                <form id="whatsappForm">
                    <div class="form-group">
                        <label for="phoneNumber">Número de WhatsApp</label>
                        <div class="input-group">
                            <div class="input-group-prepend">
                                <span class="input-group-text">+51</span>
                            </div>
                            <input type="text" class="form-control" id="phoneNumber" name="phoneNumber" 
                                   placeholder="987654321" pattern="[0-9]{9}" maxlength="9" required>
                        </div>
                        <small class="form-text text-muted">Ingrese el número de teléfono (9 dígitos)</small>
                    </div>
                    
                    <div class="form-group">
                        <label for="messageText">Plantilla de Mensaje</label>
                        <div class="template-tags">
                            <small>Etiquetas disponibles: </small>
                            <span onclick="insertTag('[Nombre]')">[Nombre]</span>
                            <span onclick="insertTag('[Usuario]')">[Usuario]</span>
                            <span onclick="insertTag('[Contraseña]')">[Contraseña]</span>
                            <span onclick="insertTag('[Fecha]')">[Fecha]</span>
                        </div>
                        <textarea class="form-control" id="messageText" name="messageText" rows="8" required>Hola [Nombre],

                        Te damos la bienvenida a nuestro sistema. A continuación, te proporcionamos tus credenciales de acceso:

📌 Usuario: [Usuario]  
🔑 Contraseña : [Contraseña]  
📅 Fecha de registro: [Fecha]

Puedes iniciar sesión con estos datos desde nuestra plataforma.

Si tienes alguna duda o necesitas asistencia, no dudes en contactarnos.

¡Saludos cordiales!  
[Tu nombre]
</textarea>
                    </div>
                </form>
            </div>
            <div class="modal-footer">
                <button type="button" class="btn btn-secondary" data-dismiss="modal">Cancelar</button>
                <button type="button" class="btn btn-success" onclick="enviarWhatsApp()">
                    <i class="fab fa-whatsapp"></i> Enviar
                </button>
            </div>
        </div>
    </div>
</div>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('js'); ?>
<!-- SweetAlert2 -->
<link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/sweetalert2@11/dist/sweetalert2.min.css">
<script src="https://cdn.jsdelivr.net/npm/sweetalert2@11"></script>

<script>
    // Función para confirmar eliminación
    function confirmarEliminacion(button) {
        Swal.fire({
            title: '¿Estás seguro?',
            text: "¡No podrás revertir esta acción!",
            icon: 'warning',
            showCancelButton: true,
            confirmButtonColor: '#d33',
            cancelButtonColor: '#3085d6',
            confirmButtonText: 'Sí, eliminar',
            cancelButtonText: 'Cancelar'
        }).then((result) => {
            if (result.isConfirmed) {
                // Enviar el formulario de eliminación
                button.closest('form').submit();
            }
        });
    }

    // Función para cambiar estado de usuario
    function cambiarEstadoUsuario(id) {
        // Verificar si es un superadmin
        fetch(`/usuarios/${id}/es-super-admin`)
            .then(response => response.json())
            .then(data => {
                if (data.es_super_admin) {
                    Swal.fire({
                        title: 'Acción no permitida',
                        text: 'No se puede cambiar el estado de un Super Administrador',
                        icon: 'error'
                    });
                    let switchElement = document.getElementById(`switch-${id}`);
                    switchElement.checked = !switchElement.checked; // Revertir el cambio
                    return;
                }

                // Si no es super-admin, proceder con el cambio
                let switchElement = document.getElementById(`switch-${id}`);
                let estado = switchElement.checked ? 1 : 0;
                let statusElement = switchElement.closest('.toggle-container').querySelector('.toggle-status');

                // Realizar la petición para cambiar el estado
                fetch(`/usuarios/${id}/estado`, {
                    method: 'POST',
                    headers: {
                        'X-CSRF-TOKEN': document.querySelector('meta[name="csrf-token"]').content,
                        'Content-Type': 'application/json'
                    },
                    body: JSON.stringify({ activo: estado })
                })
                .then(response => response.json())
                .then(data => {
                    if (data.success) {
                        // Actualizar el estado en la interfaz
                        if (estado) {
                            statusElement.textContent = 'Activo';
                            statusElement.classList.remove('inactive');
                            statusElement.classList.add('active');
                        } else {
                            statusElement.textContent = 'Inactivo';
                            statusElement.classList.remove('active');
                            statusElement.classList.add('inactive');
                        }

                        Swal.fire({
                            title: 'Estado actualizado',
                            text: `El usuario ahora está ${estado ? 'activo' : 'inactivo'}`,
                            icon: 'success',
                            timer: 1500,
                            showConfirmButton: false
                        });
                    } else {
                        Swal.fire('Error', 'No se pudo cambiar el estado', 'error');
                        switchElement.checked = !estado; // Revertir el cambio si falla
                    }
                })
                .catch(error => {
                    console.error('Error:', error);
                    Swal.fire('Error', 'Hubo un problema en la solicitud', 'error');
                    switchElement.checked = !estado; // Revertir el cambio si hay error
                });
            });
    }

    // Configurar el modal de WhatsApp
    $('#whatsappModal').on('show.bs.modal', function (event) {
        var button = $(event.relatedTarget);
        var userId = button.data('userid');
        var userName = button.data('username');
        var userEmail = button.data('useremail');
        var userDate = button.data('userdate');
        var userPassword = button.data('userpassword');
        
        // Obtener el texto del textarea
        var messageText = $('#messageText').val();
        
        // Reemplazar las etiquetas con los valores reales del usuario seleccionado
        messageText = messageText.replace(/\[Nombre\]/g, userName);
        messageText = messageText.replace(/\[Usuario\]/g, userEmail);
        messageText = messageText.replace(/\[Contraseña\]/g, userPassword);
        messageText = messageText.replace(/\[Fecha\]/g, userDate);
        
        // Actualizar el textarea con los valores reemplazados
        $('#messageText').val(messageText);
    });

    function insertTag(tag) {
        var textarea = document.getElementById('messageText');
        var startPos = textarea.selectionStart;
        var endPos = textarea.selectionEnd;
        var currentText = textarea.value;
        
        // Insertar la etiqueta en la posición actual del cursor
        textarea.value = currentText.substring(0, startPos) + tag + currentText.substring(endPos, currentText.length);
        
        // Posicionar el cursor después de la etiqueta insertada
        textarea.selectionStart = startPos + tag.length;
        textarea.selectionEnd = startPos + tag.length;
        textarea.focus();
    }

    function enviarWhatsApp() {
        var phoneNumber = $('#phoneNumber').val();
        var messageText = $('#messageText').val();
        
        // Validar número de teléfono (9 dígitos)
        if (!phoneNumber || phoneNumber.length !== 9 || !/^\d+$/.test(phoneNumber)) {
            Swal.fire('Error', 'Por favor ingrese un número peruano válido de 9 dígitos', 'error');
            return;
        }
        
        // Crear número completo con código de país
        var numeroCompleto = '+51' + phoneNumber;
        
        // Codificar el mensaje para URL
        var encodedMessage = encodeURIComponent(messageText);
        
        // Crear el enlace de WhatsApp
        var whatsappLink = `https://wa.me/${numeroCompleto}?text=${encodedMessage}`;
        
        // Abrir en nueva pestaña
        window.open(whatsappLink, '_blank');
        
        // Cerrar el modal
        $('#whatsappModal').modal('hide');
        
        // Limpiar el formulario
        $('#whatsappForm')[0].reset();
        
        Swal.fire({
            title: 'Redirigiendo a WhatsApp',
            text: 'Será redirigido a la aplicación de WhatsApp',
            icon: 'success',
            timer: 1500,
            showConfirmButton: false
        });
    }
</script>
<?php $__env->stopSection(); ?>
<?php echo $__env->make('adminlte::page', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH C:\xampp\htdocs\cinema-laravel11\resources\views/usuarios/index.blade.php ENDPATH**/ ?>