

<?php $__env->startSection('title', 'Productos'); ?>

<head>
    <link rel="icon" href="<?php echo e(asset('icons/producto.png')); ?>" type="image/x-icon">
</head>

<?php $__env->startSection('content_header'); ?>
    <h1>Lista de Productos</h1>
    
<?php $__env->stopSection(); ?>

<?php $__env->startSection('content'); ?>
<div class="d-flex justify-content-between align-items-center mb-3">
    <!-- Botón de agregar en la parte derecha -->
    <a href="<?php echo e(route('productos.create')); ?>" class="btn btn-primary shadow-lg" style="border-radius: 50px; padding: 10px 20px;">
        <i class="fas fa-plus"></i> Agregar
    </a>
</div>

<!-- Mensajes de éxito -->
<?php if(session('success')): ?>
    <div class="alert alert-success alert-dismissible fade show" role="alert">
        <strong>¡Éxito!</strong> <?php echo e(session('success')); ?>

        <button type="button" class="btn-close" data-bs-dismiss="alert" aria-label="Close"></button>
    </div>
    <style>
        /* Estilos para el deslizador de notificaciones */

    </style>
<?php endif; ?>

<!-- Tabla de productos -->
<div class="card shadow-sm">
    <div class="card-body">
        <div class="table-responsive">
            <table class="table table-hover text-center">
                <thead class="bg-primary text-white">
                    <tr>
                        <th>ID</th>
                        <th>Nombre</th>
                        <th>Imagen</th>
                        <th>Precio</th>
                        <th>Stock</th>
                        <th>Acciones</th>
                    </tr>
                </thead>
                <tbody>
                    <?php $__currentLoopData = $productos; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $producto): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                        <tr>
                            <td><?php echo e($producto->id); ?></td>
                            <td><?php echo e($producto->nombre); ?></td>
                            <td>
                                <img src="<?php echo e(asset('storage/' . $producto->imagen)); ?>" alt="<?php echo e($producto->nombre); ?>" style="width: 50px; height: 50px; object-fit: cover; border-radius: 10px;">
                            </td>
                            <td>S/ <?php echo e(number_format($producto->precio, 2)); ?></td>
                            <td>
                                <?php if($producto->stock < 5): ?>
                                    <span class="badge bg-warning text-dark p-2 fw-bold">¡Stock bajo!</span>
                                <?php else: ?>
                                    <?php echo e($producto->stock); ?>

                                <?php endif; ?>
                            </td>
                            <td class="d-flex justify-content-center gap-1">
                                <a href="<?php echo e(route('productos.edit', $producto->id)); ?>" class="btn btn-warning btn-sm rounded-pill shadow-sm">Editar</a>
                                <button type="button" class="btn btn-danger btn-sm rounded-pill shadow-sm delete-button" data-id="<?php echo e($producto->id); ?>">Eliminar</button>
                                <form id="delete-form-<?php echo e($producto->id); ?>" action="<?php echo e(route('productos.destroy', $producto->id)); ?>" method="POST" style="display: none;">
                                    <?php echo csrf_field(); ?>
                                    <?php echo method_field('DELETE'); ?>
                                </form>
                            </td>
                        </tr>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                </tbody>
            </table>
        </div>

        <div class="d-flex justify-content-center mt-4">
            <?php echo e($productos->links()); ?>

        </div>
    </div>
</div>

<?php $__env->stopSection(); ?>

<?php $__env->startSection('footer'); ?>
    <div class="text-center">
    </div>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('js'); ?>
<script src="https://cdn.jsdelivr.net/npm/sweetalert2@11"></script>
<script>
document.addEventListener('DOMContentLoaded', function () {
    const notificationIcon = document.getElementById('notificacion-stock-bajo');
    const notificationSlider = document.getElementById('notification-slider');

    if (notificationIcon && notificationSlider) {
        notificationIcon.addEventListener('mouseenter', function() {
            fetch('/api/productos/stock-bajo')
                .then(response => response.json())
                .then(data => {
                    const listElement = document.getElementById('productosStockBajoList');
                    listElement.innerHTML = '';  // Limpiamos cualquier contenido previo

                    data.forEach(producto => {
                        const listItem = document.createElement('li');
                        listItem.textContent = `${producto.nombre} - Stock: ${producto.stock}`;
                        listElement.appendChild(listItem);
                    });

                    notificationSlider.classList.add('open');
                })
                .catch(error => {
                    console.error('Error al cargar los productos:', error);
                });
        });

        document.addEventListener('click', function(event) {
            if (!notificationSlider.contains(event.target) && !notificationIcon.contains(event.target)) {
                notificationSlider.classList.remove('open');
            }
        });
    }
});

// Script para confirmación de eliminación con SweetAlert2
document.querySelectorAll('.delete-button').forEach(button => {
        button.addEventListener('click', function () {
            let id = this.getAttribute('data-id');
            Swal.fire({
                title: '¿Estás seguro?',
                text: "¡Esta acción no se puede deshacer!",
                icon: 'warning',
                showCancelButton: true,
                confirmButtonColor: '#d33',
                cancelButtonColor: '#3085d6',
                confirmButtonText: 'Sí, eliminar',
                cancelButtonText: 'Cancelar'
            }).then((result) => {
                if (result.isConfirmed) {
                    document.getElementById('delete-form-' + id).submit();
                }
            });
        });
    });

    // Mostrar notificación si el stock es bajo (menos de 5)
    <?php $__currentLoopData = $productos; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $producto): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
        <?php if($producto->stock < 5): ?>
            Swal.fire({
                title: '¡Atención!',
                text: 'El producto <?php echo e($producto->nombre); ?> tiene bajo stock (menos de 5).',
                icon: 'warning',
                timer: 3000,
                showConfirmButton: false
            });
        <?php endif; ?>
    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
</script>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('adminlte::page', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH C:\xampp\htdocs\cinema-laravel11\resources\views/productos/index.blade.php ENDPATH**/ ?>