

<?php $__env->startSection('title', 'Ventas'); ?>

<?php $__env->startSection('content_header'); ?>
    <div class="d-flex justify-content-between align-items-center">
        <h1>Historial de Ventas</h1>
        <a href="<?php echo e(route('ventas.crear')); ?>" class="btn btn-success">
            <i class="fas fa-plus"></i> Vender
        </a>
    </div>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('content'); ?>
<div class="card">
    <div class="card-header bg-primary text-white">
        <h3 class="card-title">Lista de Ventas</h3>
    </div>
    <div class="card-body">
        <table id="tabla_ventas" class="table table-striped table-bordered">
            <thead class="bg-dark text-white">
                <tr>
                    <th>ID</th>
                    <th>Cliente</th>
                    <th>Producto</th>
                    <th>Cantidad</th>
                    <th>Precio Total</th>
                    <th>Monto Pagado</th>
                    <th>Vuelto</th>
                    <th>Fecha</th>
                    <th>Acciones</th>
                </tr>
            </thead>
            <tbody>
                <?php $__currentLoopData = $ventas; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $venta): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                    <tr>
                        <td><?php echo e($venta->id); ?></td>
                        <td><?php echo e($venta->alquiler->cliente ?? 'Cliente Desconocido'); ?></td>

                        <td><?php echo e($venta->producto->nombre ?? 'Producto Eliminado'); ?></td>
                        <td><?php echo e($venta->cantidad); ?></td>
                        <td>S/ <?php echo e(number_format($venta->precio_total, 2)); ?></td>
                        <td>S/ <?php echo e(number_format($venta->monto_pagado, 2)); ?></td>
                        <td>S/ <?php echo e(number_format($venta->vuelto, 2)); ?></td>
                        <td><?php echo e($venta->created_at->format('d/m/Y H:i')); ?></td>
                        <td>
                            <button class="btn btn-danger btn-sm">Eliminar</button>
                        </td>
                    </tr>
                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
            </tbody>
        </table>
    </div>
</div>


<?php $__env->stopSection(); ?>

<?php $__env->startSection('css'); ?>
    <link rel="stylesheet" href="https://cdn.datatables.net/1.13.6/css/dataTables.bootstrap5.min.css">
<?php $__env->stopSection(); ?>

<?php $__env->startSection('js'); ?>
    <script src="https://cdn.datatables.net/1.13.6/js/jquery.dataTables.min.js"></script>
    <script src="https://cdn.datatables.net/1.13.6/js/dataTables.bootstrap5.min.js"></script>
    <script src="https://cdn.jsdelivr.net/npm/sweetalert2@11"></script>
    <script>
        $(document).ready(function() {
            $('#tabla_ventas').DataTable({
                "language": {
                    "url": "//cdn.datatables.net/plug-ins/1.13.6/i18n/Spanish.json"
                }
            });

            // Confirmación con SweetAlert antes de eliminar
            $('.formulario-eliminar').submit(function(e) {
                e.preventDefault();
                Swal.fire({
                    title: '¿Estás seguro?',
                    text: "Esta acción no se puede deshacer",
                    icon: 'warning',
                    showCancelButton: true,
                    confirmButtonColor: '#d33',
                    cancelButtonColor: '#3085d6',
                    confirmButtonText: 'Sí, eliminar',
                    cancelButtonText: 'Cancelar'
                }).then((result) => {
                    if (result.isConfirmed) {
                        this.submit();
                    }
                });
            });
        });
    </script>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('adminlte::page', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH C:\xampp\htdocs\cinema-laravel11\resources\views/ventas/ventatotal.blade.php ENDPATH**/ ?>