<!DOCTYPE html>
<html lang="es">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Reporte de Salas de Cine</title>
    <style>
        @page {
            margin: 20px;
            size: A4;
        }
        
        body {
            font-family: 'Segoe UI', Tahoma, Geneva, Verdana, sans-serif;
            margin: 0;
            padding: 0;
            color: #333;
            line-height: 1.6;
        }
        
        .header {
            text-align: center;
            margin-bottom: 30px;
            border-bottom: 2px solid #28A745;
            padding-bottom: 10px;
        }
        
        .title {
            font-size: 28px;
            font-weight: bold;
            color: #28A745;
            margin-bottom: 5px;
        }
        
        .subtitle {
            font-size: 14px;
            color: #666;
        }
        
        .logo {
            height: 80px;
            margin-bottom: 10px;
        }
        
        .info {
            display: flex;
            justify-content: space-between;
            margin-bottom: 20px;
            font-size: 12px;
            color: #555;
        }
        
        .table {
            width: 100%;
            border-collapse: collapse;
            margin-bottom: 30px;
            font-size: 12px;
        }
        
        .table th {
            background-color: #28A745;
            color: white;
            padding: 12px 8px;
            text-align: center;
            font-weight: bold;
            text-transform: uppercase;
            font-size: 12px;
        }
        
        .table td {
            padding: 10px 8px;
            border: 1px solid #e0e0e0;
            text-align: center;
        }
        
        .table tr:nth-child(even) {
            background-color: #f8f9fa;
        }
        
        .table tr:hover {
            background-color: #f1f1f1;
        }
        
        .vip {
            background-color: #fff3cd;
            font-weight: bold;
        }
        
        .footer {
            text-align: center;
            margin-top: 30px;
            padding-top: 10px;
            border-top: 1px solid #ddd;
            font-size: 10px;
            color: #777;
        }
        
        .badge {
            display: inline-block;
            padding: 4px 8px;
            border-radius: 12px;
            font-size: 11px;
            font-weight: bold;
            color: white;
        }
        
        .badge-success {
            background-color: #28a745;
        }
        
        .badge-warning {
            background-color: #ffc107;
            color: #333;
        }
        
        .badge-danger {
            background-color: #dc3545;
        }
        
        .badge-info {
            background-color: #17a2b8;
        }
    </style>
</head>
<body>
    <div class="header">
        <!-- Puedes agregar un logo si lo deseas -->
        <!-- <img src="{{ public_path('images/logo.png') }}" class="logo" alt="Logo"> -->
        <div class="title">REPORTE DE SALAS DE CINE</div>
        <div class="subtitle">Listado completo de salas disponibles</div>
    </div>
    
    <div class="info">
        <div>Fecha de generación: {{ now()->format('d/m/Y H:i') }}</div>
        <div>Total de salas: {{ count($salas) }}</div>
    </div>

    <table class="table">
        <thead>
            <tr>
                <th width="10%">ID</th>
                <th width="25%">Nombre</th>
                <th width="15%">Capacidad</th>
                <th width="20%">Tipo</th>
                <th width="20%">Estado</th>
                <th width="10%">VIP</th>
            </tr>
        </thead>
        <tbody>
            @foreach ($salas as $sala)
                <tr class="{{ $sala->tipo == 'VIP' ? 'vip' : '' }}">
                    <td>{{ $sala->id }}</td>
                    <td>{{ $sala->nombre }}</td>
                    <td>{{ $sala->capacidad }} personas</td>
                    <td>
                        @if($sala->tipo == 'VIP')
                            <span class="badge badge-warning">{{ $sala->tipo }}</span>
                        @else
                            <span class="badge badge-info">{{ $sala->tipo }}</span>
                        @endif
                    </td>
                    <td>
                        @if(strtolower($sala->estado) == 'disponible')
                            <span class="badge badge-success">{{ $sala->estado }}</span>
                        @elseif(strtolower($sala->estado) == 'ocupado')
                            <span class="badge badge-danger">{{ $sala->estado }}</span>
                        @elseif(strtolower($sala->estado) == 'mantenimiento')
                            <span class="badge" style="background-color: #6c757d;">{{ $sala->estado }}</span>
                        @else
                            {{ $sala->estado }}
                        @endif
                    </td>
                    <td>
                        @if($sala->tipo == 'VIP')
                            <i class="fas fa-check" style="color: #28a745;"></i>
                        @else
                            <i class="fas fa-times" style="color: #dc3545;"></i>
                        @endif
                    </td>
                </tr>
            @endforeach
        </tbody>
    </table>

    <div class="footer">
        © {{ date('Y') }} Sistema de Gestión de Cine. Todos los derechos reservados.
    </div>
</body>
</html>