@extends('adminlte::page')

@section('title', 'Ver Perfil')

@section('content_header')
<div class="d-flex justify-content-between align-items-center">
    <h1 class="m-0 text-dark"><i class="fas fa-user-circle mr-2"></i>Mi Perfil</h1>
    <a href="{{ url()->previous() }}" class="btn btn-outline-secondary">
        <i class="fas fa-arrow-left mr-1"></i> Volver
    </a>
</div>
@stop

@section('content')
<div class="container py-4">
    <div class="row justify-content-center">
        <div class="col-lg-8">
            <div class="card profile-card">
                <div class="row no-gutters">
                    <!-- Sidebar del Perfil -->
                    <div class="col-md-4 profile-sidebar d-flex flex-column align-items-center py-4 px-3 text-center">
                        <div class="profile-img-container mb-3">
                            @if(auth()->user()->foto)
                                <img id="profile-img" class="profile-img rounded-circle" 
                                     src="{{ asset('storage/' . auth()->user()->foto) }}" 
                                     width="120" 
                                     alt="Foto de perfil">
                            @else
                                <div class="rounded-circle bg-light d-flex align-items-center justify-content-center" 
                                     style="width: 120px; height: 120px; border: 3px solid #6777ef;">
                                    <i class="fas fa-user text-muted" style="font-size: 3rem;"></i>
                                </div>
                            @endif
                        </div>
                        <h4 class="font-weight-bold text-white mb-1">{{ auth()->user()->name }}</h4>
                        <p class="text-light mb-3">{{ auth()->user()->email }}</p>
                        
                        <div class="mt-auto">
                            <small class="text-light opacity-75">
                                <i class="fas fa-calendar-alt mr-1"></i>
                                Miembro desde: {{ auth()->user()->created_at->format('d/m/Y') }}
                            </small>
                        </div>
                    </div>
                    
                    <!-- Información del Perfil -->
                    <div class="col-md-8 form-section">
                        <div class="p-4">
                            <h4 class="section-title mb-4">Información del Perfil</h4>
                            
                            @if(session('success'))
                                <div class="alert alert-success alert-dismissible fade show">
                                    <i class="fas fa-check-circle mr-2"></i>
                                    {{ session('success') }}
                                    <button type="button" class="close" data-dismiss="alert">
                                        <span>&times;</span>
                                    </button>
                                </div>
                            @endif
                            
                            <div class="profile-info">
                                <div class="info-item mb-3">
                                    <div class="info-label">
                                        <i class="fas fa-user-tag mr-2 text-primary"></i>
                                        <span>Nombre Completo</span>
                                    </div>
                                    <div class="info-value">{{ auth()->user()->name }}</div>
                                </div>
                                
                                <div class="info-item mb-3">
                                    <div class="info-label">
                                        <i class="fas fa-at mr-2 text-primary"></i>
                                        <span>Correo Electrónico</span>
                                    </div>
                                    <div class="info-value">{{ auth()->user()->email }}</div>
                                </div>
                                
                                <div class="info-item mb-3">
                                    <div class="info-label">
                                        <i class="fas fa-id-card mr-2 text-primary"></i>
                                        <span>Rol</span>
                                    </div>
                                    <div class="info-value">
                                        @if(auth()->user()->roles->isNotEmpty())
                                            {{ auth()->user()->roles->first()->name }}
                                        @else
                                            Sin rol asignado
                                        @endif
                                    </div>
                                </div>
                                
                                <div class="info-item">
                                    <div class="info-label">
                                        <i class="fas fa-calendar-check mr-2 text-primary"></i>
                                        <span>Última actualización</span>
                                    </div>
                                    <div class="info-value">{{ auth()->user()->updated_at->format('d/m/Y H:i') }}</div>
                                </div>
                            </div>
                            
                            <div class="text-center mt-4">
                                <a href="{{ route('profile.edit') }}" class="btn btn-primary rounded-pill px-4">
                                    <i class="fas fa-edit mr-2"></i>Editar Perfil
                                </a>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>
@stop

@section('css')
<link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.4.0/css/all.min.css">
<style>
    .profile-card {
        border-radius: 12px;
        box-shadow: 0 5px 20px rgba(0, 0, 0, 0.08);
        overflow: hidden;
        border: none;
    }
    
    .profile-sidebar {
        background: linear-gradient(135deg, #6777ef 0%, #5a6bd8 100%);
        color: white;
        display: flex;
        flex-direction: column;
        justify-content: center;
    }
    
    .profile-img {
        border: 3px solid white;
        box-shadow: 0 4px 15px rgba(0, 0, 0, 0.1);
        transition: all 0.3s ease;
    }
    
    .form-section {
        background-color: #fff;
        padding: 2rem;
    }
    
    .section-title {
        position: relative;
        color: #6777ef;
        margin-bottom: 1.5rem;
        font-weight: 600;
    }
    
    .section-title:after {
        content: "";
        position: absolute;
        left: 0;
        bottom: -8px;
        width: 50px;
        height: 3px;
        background: linear-gradient(135deg, #6777ef 0%, #5a6bd8 100%);
        border-radius: 3px;
    }
    
    .profile-info {
        background-color: #f8f9fa;
        border-radius: 10px;
        padding: 1.5rem;
    }
    
    .info-item {
        display: flex;
        flex-wrap: wrap;
        align-items: center;
        padding: 0.75rem 0;
        border-bottom: 1px solid #e9ecef;
    }
    
    .info-item:last-child {
        border-bottom: none;
    }
    
    .info-label {
        flex: 0 0 40%;
        font-weight: 600;
        color: #495057;
        display: flex;
        align-items: center;
    }
    
    .info-label i {
        width: 24px;
        text-align: center;
    }
    
    .info-value {
        flex: 0 0 60%;
        color: #6c757d;
    }
    
    .btn-primary {
        background-color: #6777ef;
        border-color: #6777ef;
        transition: all 0.3s;
    }
    
    .btn-primary:hover {
        background-color: #5a6bd8;
        border-color: #5a6bd8;
        transform: translateY(-2px);
        box-shadow: 0 4px 15px rgba(103, 119, 239, 0.3);
    }
    
    .rounded-pill {
        border-radius: 50rem !important;
    }
    
    @media (max-width: 768px) {
        .profile-sidebar {
            padding: 2rem 1rem;
        }
        
        .info-label, 
        .info-value {
            flex: 0 0 100%;
        }
        
        .info-value {
            margin-top: 0.5rem;
            padding-left: 2rem;
        }
    }
</style>
@stop

@section('js')
<script>
    // Efecto hover para la imagen de perfil
    document.addEventListener('DOMContentLoaded', function() {
        const profileImg = document.getElementById('profile-img');
        if (profileImg) {
            profileImg.addEventListener('mouseenter', function() {
                this.style.transform = 'scale(1.03)';
                this.style.boxShadow = '0 6px 20px rgba(0,0,0,0.15)';
            });
            
            profileImg.addEventListener('mouseleave', function() {
                this.style.transform = 'scale(1)';
                this.style.boxShadow = '0 4px 15px rgba(0,0,0,0.1)';
            });
        }
    });
</script>
@stop