@extends('adminlte::page')

@section('title', 'Detalles de la Película')

@section('head')
    <link rel="icon" href="{{ asset('icons/pelicula.png') }}" type="image/x-icon">
    <!-- Bootstrap 5 CSS -->
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0-alpha1/dist/css/bootstrap.min.css" rel="stylesheet">
    <!-- Font Awesome -->
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.4.0/css/all.min.css">
    <!-- Google Fonts -->
    <link href="https://fonts.googleapis.com/css2?family=Poppins:wght@300;400;500;600&display=swap" rel="stylesheet">
@stop

@section('content_header')
    <div class="text-center mb-4">
        <h1 class="text-gradient">
            <i class="fas fa-film me-2"></i>Detalles de la Película
        </h1>
    </div>
@stop

@section('content')
<div class="container">
    <div class="row justify-content-center">
        <div class="col-lg-10">
            <div class="card movie-detail-card border-0">
                <div class="card-header bg-dark text-white py-4">
                    <div class="d-flex justify-content-between align-items-center">
                        <h2 class="h3 mb-0 text-white">
                            <i class="fas fa-clapperboard me-2"></i>{{ $pelicula->titulo }}
                        </h2>
                        <span class="badge bg-primary fs-6 py-2 px-3 rounded-pill">
                            ID: {{ $pelicula->id }}
                        </span>
                    </div>
                </div>
                
                <div class="card-body p-5">
                    <div class="row align-items-center">
                        <!-- Portada de la película -->
                        <div class="col-md-5 mb-4 mb-md-0 text-center">
                            <div class="movie-poster-container">
                                <img src="{{ asset('imagenes/logo3.png') }}" 
                                     alt="Portada de {{ $pelicula->titulo }}" 
                                     class="img-fluid movie-poster rounded-3 shadow">
                                <div class="movie-status-badge">
                                    <span class="badge rounded-pill fs-6 py-2 px-3 
                                        {{ $pelicula->estado == 'disponible' ? 'bg-success' : 'bg-danger' }}">
                                        <i class="fas {{ $pelicula->estado == 'disponible' ? 'fa-check' : 'fa-times' }} me-1"></i>
                                        {{ ucfirst($pelicula->estado) }}
                                    </span>
                                </div>
                            </div>
                        </div>
                        
                        <!-- Detalles de la película -->
                        <div class="col-md-7">
                            <div class="movie-details">
                                <!-- Duración -->
                                <div class="detail-card mb-4">
                                    <div class="detail-header">
                                        <i class="fas fa-clock me-2"></i>Duración
                                    </div>
                                    <div class="detail-content">
                                        <span class="duration">
                                            {{ floor($pelicula->duracion / 60) }}h {{ $pelicula->duracion % 60 }}min
                                        </span>
                                    </div>
                                </div>
                                
                                <!-- Formato -->
                                <div class="detail-card mb-4">
                                    <div class="detail-header">
                                        <i class="fas fa-compact-disc me-2"></i>Formato
                                    </div>
                                    <div class="detail-content">
                                        <span class="badge format-badge">
                                            {{ $pelicula->formato }}
                                        </span>
                                    </div>
                                </div>
                                
                                <!-- Categoría -->
                                <div class="detail-card mb-4">
                                    <div class="detail-header">
                                        <i class="fas fa-tag me-2"></i>Categoría
                                    </div>
                                    <div class="detail-content">
                                        <span class="badge category-badge">
                                            {{ $pelicula->categoria->nombre }}
                                        </span>
                                    </div>
                                </div>
                                
                                <!-- Fechas -->
                                <div class="detail-card">
                                    <div class="detail-header">
                                        <i class="fas fa-calendar-alt me-2"></i>Información
                                    </div>
                                    <div class="detail-content">
                                        <div class="row">
                                            <div class="col-md-6 mb-2 mb-md-0">
                                                <div class="info-item">
                                                    <span class="info-label">Creada:</span>
                                                    <span class="info-value">{{ $pelicula->created_at->format('d/m/Y H:i') }}</span>
                                                </div>
                                            </div>
                                            <div class="col-md-6">
                                                <div class="info-item">
                                                    <span class="info-label">Actualizada:</span>
                                                    <span class="info-value">{{ $pelicula->updated_at->format('d/m/Y H:i') }}</span>
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
                
                <div class="card-footer bg-light py-3">
                    <div class="d-flex justify-content-between align-items-center">
                        <a href="{{ route('peliculas.index') }}" class="btn btn-outline-secondary">
                            <i class="fas fa-arrow-left me-2"></i>Volver al listado
                        </a>
                        <div>
                            <a href="{{ route('peliculas.edit', $pelicula) }}" class="btn btn-primary me-2">
                                <i class="fas fa-edit me-2"></i>Editar
                            </a>
                            <form action="{{ route('peliculas.destroy', $pelicula) }}" method="POST" class="d-inline">
                                @csrf
                                @method('DELETE')
                                <button type="submit" class="btn btn-danger">
                                    <i class="fas fa-trash-alt me-2"></i>Eliminar
                                </button>
                            </form>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>
@stop

@section('css')
<style>
    body {
        font-family: 'Poppins', sans-serif;
        background-color: #f8f9fa;
    }
    
    .text-gradient {
        background: linear-gradient(135deg, #3a7bd5 0%, #00d2ff 100%);
        -webkit-background-clip: text;
        background-clip: text;
        color: transparent;
        font-weight: 600;
    }
    
    .movie-detail-card {
        border-radius: 15px;
        overflow: hidden;
        box-shadow: 0 10px 30px rgba(0, 0, 0, 0.1);
        transition: all 0.3s ease;
        background-color: white;
    }
    
    .movie-detail-card:hover {
        box-shadow: 0 15px 35px rgba(0, 0, 0, 0.15);
        transform: translateY(-5px);
    }
    
    .movie-poster-container {
        position: relative;
        display: inline-block;
    }
    
    .movie-poster {
        border: 5px solid white;
        box-shadow: 0 5px 15px rgba(0, 0, 0, 0.1);
        transition: all 0.3s ease;
        max-height: 350px;
        object-fit: cover;
    }
    
    .movie-poster:hover {
        transform: scale(1.03);
    }
    
    .movie-status-badge {
        position: absolute;
        top: 15px;
        right: 15px;
    }
    
    .detail-card {
        background-color: #f8f9fa;
        border-radius: 10px;
        padding: 1.25rem;
        box-shadow: 0 3px 10px rgba(0, 0, 0, 0.05);
    }
    
    .detail-header {
        font-size: 1rem;
        color: #6c757d;
        margin-bottom: 0.5rem;
        font-weight: 500;
    }
    
    .detail-content {
        font-size: 1.1rem;
    }
    
    .duration {
        font-size: 1.5rem;
        font-weight: 600;
        color: #3a7bd5;
    }
    
    .format-badge {
        background-color: #4b9fe1;
        color: white;
        font-size: 1rem;
        padding: 0.5rem 1rem;
    }
    
    .category-badge {
        background-color: #6f42c1;
        color: white;
        font-size: 1rem;
        padding: 0.5rem 1rem;
    }
    
    .info-item {
        display: flex;
        justify-content: space-between;
        margin-bottom: 0.5rem;
    }
    
    .info-label {
        color: #6c757d;
        font-weight: 500;
    }
    
    .info-value {
        font-weight: 600;
        color: #495057;
    }
    
    .btn {
        border-radius: 50px;
        padding: 0.5rem 1.5rem;
        font-weight: 500;
        transition: all 0.3s ease;
    }
    
    .btn:hover {
        transform: translateY(-2px);
        box-shadow: 0 5px 15px rgba(0, 0, 0, 0.1);
    }
    
    .badge {
        letter-spacing: 0.5px;
        font-weight: 500;
    }
</style>
@stop

@section('js')
<!-- Bootstrap 5 JS -->
<script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0-alpha1/dist/js/bootstrap.bundle.min.js"></script>
<!-- SweetAlert2 -->
<script src="https://cdn.jsdelivr.net/npm/sweetalert2@11"></script>

<script>
    // Confirmación para eliminar
    document.querySelector('form[action="{{ route('peliculas.destroy', $pelicula) }}"]').addEventListener('submit', function(e) {
        e.preventDefault();
        
        Swal.fire({
            title: '¿Estás seguro?',
            text: "¡Esta acción no se puede deshacer!",
            icon: 'warning',
            showCancelButton: true,
            confirmButtonColor: '#d33',
            cancelButtonColor: '#6c757d',
            confirmButtonText: 'Sí, eliminar',
            cancelButtonText: 'Cancelar',
            reverseButtons: true
        }).then((result) => {
            if (result.isConfirmed) {
                this.submit();
            }
        });
    });
</script>
@stop