<!DOCTYPE html>
<html lang="es">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Lista de Cobros</title>
    <style>
        body {
            font-family: Arial, sans-serif;
            margin: 20px;
            padding: 0;
        }
        .title {
            text-align: center;
            font-size: 24px;
            font-weight: bold;
            margin-bottom: 20px;
        }
        .table {
            width: 100%;
            border-collapse: collapse;
            margin-bottom: 20px;
        }
        .table th, .table td {
            border: 1px solid #ddd;
            padding: 10px;
            text-align: center;
        }
        .table th {
            background-color: #007BFF;
            color: white;
        }
        .table tr:nth-child(even) {
            background-color: #f2f2f2;
        }
    </style>
</head>
<body>

    <div class="title">Lista de Cobros</div>

    <table class="table">
        <thead>
            <tr>
                <th>ID</th>
                <th>Cliente</th>
                <th>Precio</th>
                <th>Película</th>
                <th>Sala</th>
                <th>Hora de Entrada</th>
                <th>Hora de Salida</th>
                <th>Fecha</th>
            </tr>
        </thead>
        <tbody>
            @foreach ($cobros as $cobro)
                <tr>
                    <td>{{ $cobro->id }}</td>
                    <td>{{ $cobro->cliente }}</td>
                    <td>S/. {{ number_format($cobro->precio, 2) }}</td>
                    <td>{{ optional($cobro->pelicula)->titulo ?? 'No asignado' }}</td>

                    <td>{{ optional($cobro->sala)->nombre ?? 'No asignado' }}</td>

                    <td>{{ $cobro->hora_entrada }}</td>
                    <td>{{ $cobro->hora_salida }}</td>
                    <td>{{ $cobro->created_at->format('d/m/Y') }}</td>
                </tr>
            @endforeach
        </tbody>
    </table>

</body>
</html>
