<?php

namespace App\Providers;

use Illuminate\Support\Facades\Gate;
use App\Models\Producto;
use Illuminate\Support\Facades\View;
use Illuminate\Support\ServiceProvider;
use Illuminate\Support\Facades\Cache;

class AppServiceProvider extends ServiceProvider
{
    
    /**
     * Registra cualquier servicio de la aplicación.
     *
     * @return void
     */
    public function register()
    {
        //
    }

    /**
     * Bootstrap cualquier servicio de la aplicación.
     *
     * @return void
     */
    public function boot()
    {
        // Permitir acceso total a super-admin sin pasar por las reglas de Gate
        Gate::before(function ($user, $ability) {
            // Si el usuario tiene el rol 'super-admin', retorna true
            return $user->hasRole('super-admin') ? true : null;
        });

        // Compartir productos con stock bajo en todas las vistas
        View::composer('*', function ($view) {
            // Definir el umbral de stock bajo (por ejemplo 5 unidades)
            $umbral = 5;

            // Usar caché para evitar consultas repetidas
            $productosStockBajo = Cache::remember('productos_stock_bajo', 60, function () use ($umbral) {
                return Producto::where('stock', '<', $umbral)->get();
            });

            // Contar cuántos productos tienen stock bajo
            $lowStockCount = $productosStockBajo->count();

            // Pasar las variables a todas las vistas
            $view->with('productosStockBajo', $productosStockBajo)
                 ->with('lowStockCount', $lowStockCount);
        });
    }
}
