<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class Venta extends Model
{
    use HasFactory;

    protected $fillable = ['producto_id', 'cantidad', 'precio_total', 'monto_pagado','vuelto','alquiler_id'];


    public function producto()
    {
        return $this->belongsTo(Producto::class, 'producto_id');
    }

    public function alquiler()
    {
        return $this->belongsTo(Alquiler::class);
    }
    
}
