<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class Producto extends Model
{
    use HasFactory;

    protected $table = 'productos'; // Nombre de la tabla en la BD

    protected $fillable = ['nombre', 'precio', 'stock', 'estado','imagen'];

    /**
     * Relación muchos a muchos con la tabla "alquileres".
     * Un producto puede estar asociado a varios alquileres.
     */
    public function alquileres()
    {
        return $this->belongsToMany(Alquiler::class, 'alquiler_producto')
                    ->withPivot('cantidad')
                    ->withTimestamps();
    }

    /**
     * Relación muchos a muchos con la tabla "cobros".
     * Un producto puede estar asociado a varios cobros.
     */
    public function cobros()
    {
        return $this->belongsToMany(Cobro::class, 'cobro_producto')
                    ->withPivot('cantidad')
                    ->withTimestamps();
    }
}