<?php

namespace App\Http\Controllers;
use App\Models\Alquiler; 
use Illuminate\Http\Request;
use App\Models\Venta; 
use Rap2hpoutre\FastExcel\FastExcel;
class ReporteController extends Controller
{
    public function index(Request $request)
    {
        // Obtener la fecha seleccionada del formulario
        $fecha = $request->get('fecha');

        // Solo filtrar si el usuario seleccionó una fecha
        if ($fecha) {
            // Obtener las ventas de esa fecha con paginación (5 registros por página)
            $ventas = Venta::whereDate('created_at', $fecha)->paginate(5);
            // Calcular el total vendido (sumando la columna precio_total)
            $totalVendido = $ventas->sum('precio_total');

            // Obtener los alquileres de esa fecha con paginación (5 registros por página)
            $alquileres = Alquiler::whereDate('created_at', $fecha)->paginate(5);
            // Calcular el total de alquileres (sumando el precio)
            $totalAlquileres = $alquileres->sum('precio');

            return view('reporte.index', compact('ventas', 'totalVendido', 'alquileres', 'totalAlquileres', 'fecha'));
        }

        // Si no se seleccionó fecha, retornar la vista sin mostrar reporte
        return view('reporte.index');
    }
    // Método para exportar ventas a Excel
    public function exportVentasExcel(Request $request)
    {
        // Obtener la fecha seleccionada
        $fechaSeleccionada = $request->input('fecha');
    
        // Filtrar las ventas por la fecha seleccionada
        $ventas = Venta::whereDate('created_at', $fechaSeleccionada)->get();
    
        // Verificar si hay ventas para esa fecha
        if ($ventas->isEmpty()) {
            return redirect()->back()->with('error', 'No se encontraron ventas para la fecha seleccionada.');
        }
    
        // Exportar a Excel
        return (new FastExcel($ventas))->download('ventas_' . $fechaSeleccionada . '.xlsx', function ($venta) {
            return [
                'ID' => $venta->id,
                'Producto' => $venta->producto->nombre,
                'Cantidad' => $venta->cantidad,
                'Precio Total' => $venta->precio_total,
                'Hora' => $venta->created_at->format('H:i:s'),
            ];
        });
    }
    


    public function exportAlquileresExcel(Request $request)
    {
        // Obtener la fecha seleccionada
        $fechaSeleccionada = $request->input('fecha');
    
        // Filtrar los alquileres por la fecha seleccionada
        $alquileres = Alquiler::whereDate('created_at', $fechaSeleccionada)->get();
    
        // Verificar si hay alquileres para esa fecha
        if ($alquileres->isEmpty()) {
            return redirect()->back()->with('error', 'No se encontraron alquileres para la fecha seleccionada.');
        }
    
        // Exportar a Excel
        return (new FastExcel($alquileres))->download('alquileres_' . $fechaSeleccionada . '.xlsx', function ($alquiler) {
            return [
                'ID' => $alquiler->id,
                'Cliente' => $alquiler->cliente,
                'Precio' => $alquiler->precio,
                'Hora' => $alquiler->created_at->format('H:i:s'),
            ];
        });
    }
    
    
}
