<?php

namespace App\Http\Controllers;
use Illuminate\Support\Facades\Log;

use Illuminate\Http\Request;
use App\Models\Cobro;
use App\Models\Pelicula;
use App\Models\Alquiler;
use App\Models\Sala;
use DB;

class DashboardController extends Controller
{
    public function index(Request $request)
    {
        // Obtener las fechas del filtro desde la solicitud (si existen)
        $startDate = $request->input('startDate', now()->subDays(7)->format('Y-m-d'));
        $endDate = $request->input('endDate', now()->format('Y-m-d'));
    
        // Totales generales
        $totalPeliculas = Pelicula::count();
        $totalAlquileres = Alquiler::count();
        $totalSalas = Sala::count();
    
        // Contar salas ocupadas
        $salasOcupadas = Sala::where('estado', 'ocupado')->count();
    
        // Salas disponibles
        $salasDisponibles = max(0, $totalSalas - $salasOcupadas);
    
        // Alerta si hay pocas salas
        $alertaSalas = $salasDisponibles < 5;
    
        // Total cobros por alquiler
        $totalCobros = Alquiler::sum('precio') ?? 0;
    
        // Ingresos de la semana
        $ingresosSemana = Alquiler::whereBetween('created_at', [now()->subDays(7), now()])
            ->sum('precio') ?? 0;
    
        // Ingresos del mes actual
        $ingresosMes = Alquiler::whereMonth('created_at', now()->month)
            ->sum('precio') ?? 0;
    
        // Ingresos por día para gráfico
        $ingresosPorDiaQuery = Alquiler::join('peliculas', 'alquileres.pelicula_id', '=', 'peliculas.id')
            ->selectRaw('DATE(alquileres.created_at) as fecha, SUM(alquileres.precio) as total')
            ->groupBy('fecha')
            ->orderBy('fecha', 'DESC')
            ->whereBetween('alquileres.created_at', [$startDate, $endDate]);
    
        $ingresosPorDia = $ingresosPorDiaQuery->get();
        $fechas = $ingresosPorDia->pluck('fecha')->toArray();
        $montos = $ingresosPorDia->pluck('total')->toArray();
    
        // Top 5 películas más rentadas
        $topPeliculas = DB::table('alquileres')
            ->join('peliculas', 'alquileres.pelicula_id', '=', 'peliculas.id')
            ->select('peliculas.titulo as nombre', DB::raw('COUNT(alquileres.id) as total'))
            ->groupBy('peliculas.titulo')
            ->orderByDesc('total')
            ->limit(5)
            ->get();
    
        // Últimos cobros
        $ultimosCobros = Cobro::join('alquileres', 'cobros.alquiler_id', '=', 'alquileres.id')
            ->join('peliculas', 'alquileres.pelicula_id', '=', 'peliculas.id')
            ->select('cobros.fecha_cobro', 'peliculas.titulo', 'alquileres.precio')
            ->orderByDesc('cobros.fecha_cobro')
            ->limit(3)
            ->get();
    
        // Ingresos diarios
        $ingresosDiariosPeliculas = Alquiler::whereDate('created_at', now())->sum('precio');
        $ingresosDiariosProductos = DB::table('ventas')
            ->whereDate('created_at', now())
            ->sum('precio_total'); // Asegúrate que el campo se llama 'total'
    
        // Ingresos por tipo y totales
        $ventasAlquiler = Alquiler::whereBetween('created_at', [$startDate, $endDate])->sum('precio');
        $ventasProductos = DB::table('ventas')
            ->whereBetween('created_at', [$startDate, $endDate])
            ->sum('precio_total');
        $ventasTotales = $ventasAlquiler + $ventasProductos;
    // Ingreso diario total (alquiler + productos)
$ingresosTotalesHoy = Alquiler::whereDate('created_at', now())->sum('precio')
+ DB::table('ventas')->whereDate('created_at', now())->sum('precio_total'); // Ajusta el campo aquí si se llama distinto

        // Vista
        return view('dashboard', compact(
            'totalPeliculas', 'totalAlquileres', 'totalSalas', 'salasDisponibles', 'alertaSalas',
            'totalCobros', 'ingresosSemana', 'ingresosMes', 'fechas', 'montos',
            'topPeliculas', 'ultimosCobros', 'startDate', 'endDate',
            'ventasAlquiler', 'ventasProductos', 'ventasTotales',
            'ingresosDiariosPeliculas', 'ingresosDiariosProductos','ingresosTotalesHoy'
        ));
    }
    
    
    


    public function ingresosDiarios(Request $request) {
        // Obtenemos las fechas del filtro
        $startDate = $request->input('startDate');
        $endDate = $request->input('endDate');
        
        // Verificar si las fechas están definidas
        if (!$startDate || !$endDate) {
            return response()->json(['error' => 'Fechas no válidas'], 400);
        }
        
        // Consultar ingresos por día basado en las fechas
        $ingresosPorDia = Alquiler::join('peliculas', 'alquileres.pelicula_id', '=', 'peliculas.id')
            ->selectRaw('DATE(alquileres.created_at) as fecha, SUM(alquileres.precio) as total')
            ->groupBy('fecha')
            ->whereBetween('alquileres.created_at', [$startDate, $endDate])
            ->get();
        
        // Si no hay datos, retornar un array vacío para las fechas y montos
        if ($ingresosPorDia->isEmpty()) {
            return response()->json([
                'fechas' => [],
                'montos' => []
            ]);
        }
        
        // Devolver los datos
        return response()->json([
            'fechas' => $ingresosPorDia->pluck('fecha')->toArray(),
            'montos' => $ingresosPorDia->pluck('total')->toArray()
        ]);
    }
    
    
    public function getUltimosCobros()
    {
        $ultimosCobros = Cobro::join('alquileres', 'cobros.alquiler_id', '=', 'alquileres.id')
            ->join('peliculas', 'alquileres.pelicula_id', '=', 'peliculas.id')
            ->select('cobros.fecha_cobro', 'peliculas.titulo', 'alquileres.precio')
            ->orderByDesc('cobros.fecha_cobro') // Ordenar por la fecha del cobro
            ->limit(3)
            ->get();
    
        return response()->json($ultimosCobros);
    }
    

}
